@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.CostAllocationRulePropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.CostAllocationRulePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CostAllocationRule].
 */
@PulumiTagMarker
public class CostAllocationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CostAllocationRuleArgs = CostAllocationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CostAllocationRuleArgsBuilder.() -> Unit) {
        val builder = CostAllocationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CostAllocationRule {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.CostAllocationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CostAllocationRule(builtJavaResource)
    }
}

/**
 * The cost allocation rule model definition
 * Azure REST API version: 2020-03-01-preview. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * Other available API versions: 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CostAllocationRulesCreateResourceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var costAllocationRule = new AzureNative.CostManagement.CostAllocationRule("costAllocationRule", new()
 *     {
 *         BillingAccountId = "100",
 *         Properties = new AzureNative.CostManagement.Inputs.CostAllocationRulePropertiesArgs
 *         {
 *             Description = "This is a testRule",
 *             Details = new AzureNative.CostManagement.Inputs.CostAllocationRuleDetailsArgs
 *             {
 *                 SourceResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.SourceCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             "sampleRG",
 *                             "secondRG",
 *                         },
 *                     },
 *                 },
 *                 TargetResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.TargetCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         PolicyType = AzureNative.CostManagement.CostAllocationPolicyType.FixedProportion,
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG",
 *                                 Percentage = 45,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG2",
 *                                 Percentage = 54,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             Status = AzureNative.CostManagement.RuleStatus.Active,
 *         },
 *         RuleName = "testRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCostAllocationRule(ctx, "costAllocationRule", &costmanagement.CostAllocationRuleArgs{
 * 			BillingAccountId: pulumi.String("100"),
 * 			Properties: &costmanagement.CostAllocationRulePropertiesArgs{
 * 				Description: pulumi.String("This is a testRule"),
 * 				Details: &costmanagement.CostAllocationRuleDetailsArgs{
 * 					SourceResources: costmanagement.SourceCostAllocationResourceArray{
 * 						&costmanagement.SourceCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("sampleRG"),
 * 								pulumi.String("secondRG"),
 * 							},
 * 						},
 * 					},
 * 					TargetResources: costmanagement.TargetCostAllocationResourceArray{
 * 						&costmanagement.TargetCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							PolicyType:   pulumi.String(costmanagement.CostAllocationPolicyTypeFixedProportion),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: costmanagement.CostAllocationProportionArray{
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG"),
 * 									Percentage: pulumi.Float64(45),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG2"),
 * 									Percentage: pulumi.Float64(54),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Status: pulumi.String(costmanagement.RuleStatusActive),
 * 			},
 * 			RuleName: pulumi.String("testRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRule;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAllocationRule = new CostAllocationRule("costAllocationRule", CostAllocationRuleArgs.builder()
 *             .billingAccountId("100")
 *             .properties(CostAllocationRulePropertiesArgs.builder()
 *                 .description("This is a testRule")
 *                 .details(CostAllocationRuleDetailsArgs.builder()
 *                     .sourceResources(SourceCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             "sampleRG",
 *                             "secondRG")
 *                         .build())
 *                     .targetResources(TargetCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .policyType("FixedProportion")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG")
 *                                 .percentage(45)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG2")
 *                                 .percentage(54)
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .status("Active")
 *                 .build())
 *             .ruleName("testRule")
 *             .build());
 *     }
 * }
 * ```
 * ### CostAllocationRulesCreateTag
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var costAllocationRule = new AzureNative.CostManagement.CostAllocationRule("costAllocationRule", new()
 *     {
 *         BillingAccountId = "100",
 *         Properties = new AzureNative.CostManagement.Inputs.CostAllocationRulePropertiesArgs
 *         {
 *             Description = "This is a testRule",
 *             Details = new AzureNative.CostManagement.Inputs.CostAllocationRuleDetailsArgs
 *             {
 *                 SourceResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.SourceCostAllocationResourceArgs
 *                     {
 *                         Name = "category",
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Tag,
 *                         Values = new[]
 *                         {
 *                             "devops",
 *                         },
 *                     },
 *                 },
 *                 TargetResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.TargetCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         PolicyType = AzureNative.CostManagement.CostAllocationPolicyType.FixedProportion,
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG",
 *                                 Percentage = 33.33,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG2",
 *                                 Percentage = 33.33,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG3",
 *                                 Percentage = 33.34,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             Status = AzureNative.CostManagement.RuleStatus.Active,
 *         },
 *         RuleName = "testRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCostAllocationRule(ctx, "costAllocationRule", &costmanagement.CostAllocationRuleArgs{
 * 			BillingAccountId: pulumi.String("100"),
 * 			Properties: &costmanagement.CostAllocationRulePropertiesArgs{
 * 				Description: pulumi.String("This is a testRule"),
 * 				Details: &costmanagement.CostAllocationRuleDetailsArgs{
 * 					SourceResources: costmanagement.SourceCostAllocationResourceArray{
 * 						&costmanagement.SourceCostAllocationResourceArgs{
 * 							Name:         pulumi.String("category"),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeTag),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("devops"),
 * 							},
 * 						},
 * 					},
 * 					TargetResources: costmanagement.TargetCostAllocationResourceArray{
 * 						&costmanagement.TargetCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							PolicyType:   pulumi.String(costmanagement.CostAllocationPolicyTypeFixedProportion),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: costmanagement.CostAllocationProportionArray{
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG"),
 * 									Percentage: pulumi.Float64(33.33),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG2"),
 * 									Percentage: pulumi.Float64(33.33),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG3"),
 * 									Percentage: pulumi.Float64(33.34),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Status: pulumi.String(costmanagement.RuleStatusActive),
 * 			},
 * 			RuleName: pulumi.String("testRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRule;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAllocationRule = new CostAllocationRule("costAllocationRule", CostAllocationRuleArgs.builder()
 *             .billingAccountId("100")
 *             .properties(CostAllocationRulePropertiesArgs.builder()
 *                 .description("This is a testRule")
 *                 .details(CostAllocationRuleDetailsArgs.builder()
 *                     .sourceResources(SourceCostAllocationResourceArgs.builder()
 *                         .name("category")
 *                         .resourceType("Tag")
 *                         .values("devops")
 *                         .build())
 *                     .targetResources(TargetCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .policyType("FixedProportion")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG")
 *                                 .percentage(33.33)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG2")
 *                                 .percentage(33.33)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG3")
 *                                 .percentage(33.34)
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .status("Active")
 *                 .build())
 *             .ruleName("testRule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:CostAllocationRule testRule /providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/costAllocationRules/{ruleName}
 * ```
 */
public class CostAllocationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.CostAllocationRule,
) : KotlinCustomResource(javaResource, CostAllocationRuleMapper) {
    /**
     * Name of the rule. This is a read only value.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Cost allocation rule properties
     */
    public val properties: Output<CostAllocationRulePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type of the rule. This is a read only value of Microsoft.CostManagement/CostAllocationRule.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CostAllocationRuleMapper : ResourceMapper<CostAllocationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.CostAllocationRule::class == javaResource::class

    override fun map(javaResource: Resource): CostAllocationRule = CostAllocationRule(
        javaResource as
            com.pulumi.azurenative.costmanagement.CostAllocationRule,
    )
}

/**
 * @see [CostAllocationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CostAllocationRule].
 */
public suspend fun costAllocationRule(
    name: String,
    block: suspend CostAllocationRuleResourceBuilder.() -> Unit,
): CostAllocationRule {
    val builder = CostAllocationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CostAllocationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun costAllocationRule(name: String): CostAllocationRule {
    val builder = CostAllocationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
