@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.CustomerMetadataResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.CustomerMetadataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MarkupRule].
 */
@PulumiTagMarker
public class MarkupRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MarkupRuleArgs = MarkupRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MarkupRuleArgsBuilder.() -> Unit) {
        val builder = MarkupRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MarkupRule {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.MarkupRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MarkupRule(builtJavaResource)
    }
}

/**
 * Markup rule
 * Azure REST API version: 2022-10-05-preview.
 * ## Example Usage
 * ### CreateOrUpdatePrivateMarkupRules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var markupRule = new AzureNative.CostManagement.MarkupRule("markupRule", new()
 *     {
 *         BillingAccountId = "2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6",
 *         BillingProfileId = "cbf78278-f4b8-43d9-8f13-47112da1c63e",
 *         CustomerDetails = new AzureNative.CostManagement.Inputs.CustomerMetadataArgs
 *         {
 *             BillingAccountId = "cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9",
 *             BillingProfileId = "08eeecee-efb2-40d5-817c-0a254d2e042c",
 *         },
 *         Description = "Markup rule for year 2022",
 *         EndDate = "2022-12-31T00:00:00Z",
 *         Name = "markup-2022",
 *         Percentage = 5,
 *         StartDate = "2022-01-01T00:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewMarkupRule(ctx, "markupRule", &costmanagement.MarkupRuleArgs{
 * 			BillingAccountId: pulumi.String("2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6"),
 * 			BillingProfileId: pulumi.String("cbf78278-f4b8-43d9-8f13-47112da1c63e"),
 * 			CustomerDetails: &costmanagement.CustomerMetadataArgs{
 * 				BillingAccountId: pulumi.String("cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9"),
 * 				BillingProfileId: pulumi.String("08eeecee-efb2-40d5-817c-0a254d2e042c"),
 * 			},
 * 			Description: pulumi.String("Markup rule for year 2022"),
 * 			EndDate:     pulumi.String("2022-12-31T00:00:00Z"),
 * 			Name:        pulumi.String("markup-2022"),
 * 			Percentage:  pulumi.Float64(5),
 * 			StartDate:   pulumi.String("2022-01-01T00:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.MarkupRule;
 * import com.pulumi.azurenative.costmanagement.MarkupRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var markupRule = new MarkupRule("markupRule", MarkupRuleArgs.builder()
 *             .billingAccountId("2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6")
 *             .billingProfileId("cbf78278-f4b8-43d9-8f13-47112da1c63e")
 *             .customerDetails(CustomerMetadataArgs.builder()
 *                 .billingAccountId("cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9")
 *                 .billingProfileId("08eeecee-efb2-40d5-817c-0a254d2e042c")
 *                 .build())
 *             .description("Markup rule for year 2022")
 *             .endDate("2022-12-31T00:00:00Z")
 *             .name("markup-2022")
 *             .percentage(5)
 *             .startDate("2022-01-01T00:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:MarkupRule markup-2022 /providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/markupRules/{name}
 * ```
 */
public class MarkupRule internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.MarkupRule,
) : KotlinCustomResource(javaResource, MarkupRuleMapper) {
    /**
     * Customer information for the markup rule.
     */
    public val customerDetails: Output<CustomerMetadataResponse>
        get() = javaResource.customerDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The description of the markup rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Ending date of the markup rule.
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The markup percentage of the rule.
     */
    public val percentage: Output<Double>
        get() = javaResource.percentage().applyValue({ args0 -> args0 })

    /**
     * Starting date of the markup rule.
     */
    public val startDate: Output<String>
        get() = javaResource.startDate().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MarkupRuleMapper : ResourceMapper<MarkupRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.MarkupRule::class == javaResource::class

    override fun map(javaResource: Resource): MarkupRule = MarkupRule(
        javaResource as
            com.pulumi.azurenative.costmanagement.MarkupRule,
    )
}

/**
 * @see [MarkupRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MarkupRule].
 */
public suspend fun markupRule(name: String, block: suspend MarkupRuleResourceBuilder.() -> Unit): MarkupRule {
    val builder = MarkupRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MarkupRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun markupRule(name: String): MarkupRule {
    val builder = MarkupRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
