@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.MarkupRuleArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.CustomerMetadataArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.CustomerMetadataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Markup rule
 * Azure REST API version: 2022-10-05-preview.
 * ## Example Usage
 * ### CreateOrUpdatePrivateMarkupRules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var markupRule = new AzureNative.CostManagement.MarkupRule("markupRule", new()
 *     {
 *         BillingAccountId = "2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6",
 *         BillingProfileId = "cbf78278-f4b8-43d9-8f13-47112da1c63e",
 *         CustomerDetails = new AzureNative.CostManagement.Inputs.CustomerMetadataArgs
 *         {
 *             BillingAccountId = "cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9",
 *             BillingProfileId = "08eeecee-efb2-40d5-817c-0a254d2e042c",
 *         },
 *         Description = "Markup rule for year 2022",
 *         EndDate = "2022-12-31T00:00:00Z",
 *         Name = "markup-2022",
 *         Percentage = 5,
 *         StartDate = "2022-01-01T00:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewMarkupRule(ctx, "markupRule", &costmanagement.MarkupRuleArgs{
 * 			BillingAccountId: pulumi.String("2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6"),
 * 			BillingProfileId: pulumi.String("cbf78278-f4b8-43d9-8f13-47112da1c63e"),
 * 			CustomerDetails: &costmanagement.CustomerMetadataArgs{
 * 				BillingAccountId: pulumi.String("cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9"),
 * 				BillingProfileId: pulumi.String("08eeecee-efb2-40d5-817c-0a254d2e042c"),
 * 			},
 * 			Description: pulumi.String("Markup rule for year 2022"),
 * 			EndDate:     pulumi.String("2022-12-31T00:00:00Z"),
 * 			Name:        pulumi.String("markup-2022"),
 * 			Percentage:  pulumi.Float64(5),
 * 			StartDate:   pulumi.String("2022-01-01T00:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.MarkupRule;
 * import com.pulumi.azurenative.costmanagement.MarkupRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var markupRule = new MarkupRule("markupRule", MarkupRuleArgs.builder()
 *             .billingAccountId("2af90bea-080c-438c-8977-17cddd5f115a:ef5ce3cf-f5af-4fcb-a5ed-c376e1d6d2b6")
 *             .billingProfileId("cbf78278-f4b8-43d9-8f13-47112da1c63e")
 *             .customerDetails(CustomerMetadataArgs.builder()
 *                 .billingAccountId("cff9aa6d-941c-43f2-b6cb-1d2bb34a02b4:780237f3-1aa6-4159-943b-498e0d647dd9")
 *                 .billingProfileId("08eeecee-efb2-40d5-817c-0a254d2e042c")
 *                 .build())
 *             .description("Markup rule for year 2022")
 *             .endDate("2022-12-31T00:00:00Z")
 *             .name("markup-2022")
 *             .percentage(5)
 *             .startDate("2022-01-01T00:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:MarkupRule markup-2022 /providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/markupRules/{name}
 * ```
 * @property billingAccountId BillingAccount ID
 * @property billingProfileId BillingProfile ID
 * @property customerDetails Customer information for the markup rule.
 * @property description The description of the markup rule.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property endDate Ending date of the markup rule.
 * @property name Markup rule name.
 * @property percentage The markup percentage of the rule.
 * @property startDate Starting date of the markup rule.
 */
public data class MarkupRuleArgs(
    public val billingAccountId: Output<String>? = null,
    public val billingProfileId: Output<String>? = null,
    public val customerDetails: Output<CustomerMetadataArgs>? = null,
    public val description: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val name: Output<String>? = null,
    public val percentage: Output<Double>? = null,
    public val startDate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.MarkupRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.MarkupRuleArgs =
        com.pulumi.azurenative.costmanagement.MarkupRuleArgs.builder()
            .billingAccountId(billingAccountId?.applyValue({ args0 -> args0 }))
            .billingProfileId(billingProfileId?.applyValue({ args0 -> args0 }))
            .customerDetails(customerDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .percentage(percentage?.applyValue({ args0 -> args0 }))
            .startDate(startDate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarkupRuleArgs].
 */
@PulumiTagMarker
public class MarkupRuleArgsBuilder internal constructor() {
    private var billingAccountId: Output<String>? = null

    private var billingProfileId: Output<String>? = null

    private var customerDetails: Output<CustomerMetadataArgs>? = null

    private var description: Output<String>? = null

    private var eTag: Output<String>? = null

    private var endDate: Output<String>? = null

    private var name: Output<String>? = null

    private var percentage: Output<Double>? = null

    private var startDate: Output<String>? = null

    /**
     * @param value BillingAccount ID
     */
    @JvmName("mwsuadlplopotkqb")
    public suspend fun billingAccountId(`value`: Output<String>) {
        this.billingAccountId = value
    }

    /**
     * @param value BillingProfile ID
     */
    @JvmName("mtpislhpmhchpfgc")
    public suspend fun billingProfileId(`value`: Output<String>) {
        this.billingProfileId = value
    }

    /**
     * @param value Customer information for the markup rule.
     */
    @JvmName("vkpyjnqnmncwftbu")
    public suspend fun customerDetails(`value`: Output<CustomerMetadataArgs>) {
        this.customerDetails = value
    }

    /**
     * @param value The description of the markup rule.
     */
    @JvmName("lsyuegbgcjqpsqqk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("sxroqgakypsoojkq")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Ending date of the markup rule.
     */
    @JvmName("tikdufvykphxkkcf")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value Markup rule name.
     */
    @JvmName("ikuncgknunecnvjw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The markup percentage of the rule.
     */
    @JvmName("nkkuiotgkteapiis")
    public suspend fun percentage(`value`: Output<Double>) {
        this.percentage = value
    }

    /**
     * @param value Starting date of the markup rule.
     */
    @JvmName("kcgrkqflyswtgeig")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value BillingAccount ID
     */
    @JvmName("ohpswvvibnkfjyts")
    public suspend fun billingAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountId = mapped
    }

    /**
     * @param value BillingProfile ID
     */
    @JvmName("xpvleskrxbqkmiri")
    public suspend fun billingProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingProfileId = mapped
    }

    /**
     * @param value Customer information for the markup rule.
     */
    @JvmName("ilnabnwqtphcjocs")
    public suspend fun customerDetails(`value`: CustomerMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerDetails = mapped
    }

    /**
     * @param argument Customer information for the markup rule.
     */
    @JvmName("fprsetvhjigvrxxa")
    public suspend fun customerDetails(argument: suspend CustomerMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = CustomerMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customerDetails = mapped
    }

    /**
     * @param value The description of the markup rule.
     */
    @JvmName("hhigvineybfoiwpe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("rwtemcyhdwffxwhl")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Ending date of the markup rule.
     */
    @JvmName("fhkyhqphhotvrgtd")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value Markup rule name.
     */
    @JvmName("obdllvsdknjwcymo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The markup percentage of the rule.
     */
    @JvmName("llhgtqbckhdusrjx")
    public suspend fun percentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    /**
     * @param value Starting date of the markup rule.
     */
    @JvmName("tjtpggvyphstefrv")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    internal fun build(): MarkupRuleArgs = MarkupRuleArgs(
        billingAccountId = billingAccountId,
        billingProfileId = billingProfileId,
        customerDetails = customerDetails,
        description = description,
        eTag = eTag,
        endDate = endDate,
        name = name,
        percentage = percentage,
        startDate = startDate,
    )
}
