@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ReportArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.FormatType
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDefinitionArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDefinitionArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDeliveryInfoArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDeliveryInfoArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportScheduleArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportScheduleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A report resource.
 * Azure REST API version: 2018-08-01-preview. Prior API version in Azure Native 1.x: 2018-08-01-preview.
 * @property definition Has definition for the report.
 * @property deliveryInfo Has delivery information for the report.
 * @property format The format of the report being delivered.
 * @property reportName Report Name.
 * @property schedule Has schedule information for the report.
 */
public data class ReportArgs(
    public val definition: Output<ReportDefinitionArgs>? = null,
    public val deliveryInfo: Output<ReportDeliveryInfoArgs>? = null,
    public val format: Output<Either<String, FormatType>>? = null,
    public val reportName: Output<String>? = null,
    public val schedule: Output<ReportScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ReportArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ReportArgs =
        com.pulumi.azurenative.costmanagement.ReportArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deliveryInfo(deliveryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReportArgs].
 */
@PulumiTagMarker
public class ReportArgsBuilder internal constructor() {
    private var definition: Output<ReportDefinitionArgs>? = null

    private var deliveryInfo: Output<ReportDeliveryInfoArgs>? = null

    private var format: Output<Either<String, FormatType>>? = null

    private var reportName: Output<String>? = null

    private var schedule: Output<ReportScheduleArgs>? = null

    /**
     * @param value Has definition for the report.
     */
    @JvmName("kftjvskgicrfeuan")
    public suspend fun definition(`value`: Output<ReportDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Has delivery information for the report.
     */
    @JvmName("wwpjfmgbnivdiicc")
    public suspend fun deliveryInfo(`value`: Output<ReportDeliveryInfoArgs>) {
        this.deliveryInfo = value
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("liwsbegwwjubehwq")
    public suspend fun format(`value`: Output<Either<String, FormatType>>) {
        this.format = value
    }

    /**
     * @param value Report Name.
     */
    @JvmName("ssjxnkmppvyhnljo")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Has schedule information for the report.
     */
    @JvmName("svukcgtuivrptkyl")
    public suspend fun schedule(`value`: Output<ReportScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Has definition for the report.
     */
    @JvmName("hvjdltwjywdhdnob")
    public suspend fun definition(`value`: ReportDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Has definition for the report.
     */
    @JvmName("vrkwphdkhpwokqot")
    public suspend fun definition(argument: suspend ReportDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Has delivery information for the report.
     */
    @JvmName("yboluhunkgwufbeg")
    public suspend fun deliveryInfo(`value`: ReportDeliveryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryInfo = mapped
    }

    /**
     * @param argument Has delivery information for the report.
     */
    @JvmName("hwrdamfhfihxjjdh")
    public suspend fun deliveryInfo(argument: suspend ReportDeliveryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDeliveryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryInfo = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("hirnatsqulwgcmay")
    public suspend fun format(`value`: Either<String, FormatType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("jsdwelmvnpgikoju")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("kjmduerntiembylj")
    public fun format(`value`: FormatType) {
        val toBeMapped = Either.ofRight<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("prdcoxntrxsvdjls")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value Has schedule information for the report.
     */
    @JvmName("gligmvvvqnvpppgt")
    public suspend fun schedule(`value`: ReportScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Has schedule information for the report.
     */
    @JvmName("aqxhxuqvogerktgy")
    public suspend fun schedule(argument: suspend ReportScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ReportScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): ReportArgs = ReportArgs(
        definition = definition,
        deliveryInfo = deliveryInfo,
        format = format,
        reportName = reportName,
        schedule = schedule,
    )
}
