@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.FileDestinationResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.NotificationPropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.SchedulePropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.costmanagement.kotlin.outputs.FileDestinationResponse.Companion.toKotlin as fileDestinationResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.NotificationPropertiesResponse.Companion.toKotlin as notificationPropertiesResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.SchedulePropertiesResponse.Companion.toKotlin as schedulePropertiesResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ScheduledActionByScope].
 */
@PulumiTagMarker
public class ScheduledActionByScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledActionByScopeArgs = ScheduledActionByScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledActionByScopeArgsBuilder.() -> Unit) {
        val builder = ScheduledActionByScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScheduledActionByScope {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.ScheduledActionByScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScheduledActionByScope(builtJavaResource)
    }
}

/**
 * Scheduled action definition.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-04-01-preview, 2023-07-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdateInsightAlertScheduledActionByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledActionByScope = new AzureNative.CostManagement.ScheduledActionByScope("scheduledActionByScope", new()
 *     {
 *         DisplayName = "Daily anomaly by resource",
 *         Kind = AzureNative.CostManagement.ScheduledActionKind.InsightAlert,
 *         Name = "dailyAnomalyByResource",
 *         Notification = new AzureNative.CostManagement.Inputs.NotificationPropertiesArgs
 *         {
 *             Subject = "Cost anomaly detected in the resource",
 *             To = new[]
 *             {
 *                 "user@gmail.com",
 *                 "team@gmail.com",
 *             },
 *         },
 *         Schedule = new AzureNative.CostManagement.Inputs.SchedulePropertiesArgs
 *         {
 *             EndDate = "2021-06-19T22:21:51.1287144Z",
 *             Frequency = AzureNative.CostManagement.ScheduleFrequency.Daily,
 *             StartDate = "2020-06-19T22:21:51.1287144Z",
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Status = AzureNative.CostManagement.ScheduledActionStatus.Enabled,
 *         ViewId = "/providers/Microsoft.CostManagement/views/swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewScheduledActionByScope(ctx, "scheduledActionByScope", &costmanagement.ScheduledActionByScopeArgs{
 * 			DisplayName: pulumi.String("Daily anomaly by resource"),
 * 			Kind:        pulumi.String(costmanagement.ScheduledActionKindInsightAlert),
 * 			Name:        pulumi.String("dailyAnomalyByResource"),
 * 			Notification: &costmanagement.NotificationPropertiesArgs{
 * 				Subject: pulumi.String("Cost anomaly detected in the resource"),
 * 				To: pulumi.StringArray{
 * 					pulumi.String("user@gmail.com"),
 * 					pulumi.String("team@gmail.com"),
 * 				},
 * 			},
 * 			Schedule: &costmanagement.SchedulePropertiesArgs{
 * 				EndDate:   pulumi.String("2021-06-19T22:21:51.1287144Z"),
 * 				Frequency: pulumi.String(costmanagement.ScheduleFrequencyDaily),
 * 				StartDate: pulumi.String("2020-06-19T22:21:51.1287144Z"),
 * 			},
 * 			Scope:  pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Status: pulumi.String(costmanagement.ScheduledActionStatusEnabled),
 * 			ViewId: pulumi.String("/providers/Microsoft.CostManagement/views/swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScope;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledActionByScope = new ScheduledActionByScope("scheduledActionByScope", ScheduledActionByScopeArgs.builder()
 *             .displayName("Daily anomaly by resource")
 *             .kind("InsightAlert")
 *             .name("dailyAnomalyByResource")
 *             .notification(NotificationPropertiesArgs.builder()
 *                 .subject("Cost anomaly detected in the resource")
 *                 .to(
 *                     "user@gmail.com",
 *                     "team@gmail.com")
 *                 .build())
 *             .schedule(SchedulePropertiesArgs.builder()
 *                 .endDate("2021-06-19T22:21:51.1287144Z")
 *                 .frequency("Daily")
 *                 .startDate("2020-06-19T22:21:51.1287144Z")
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .status("Enabled")
 *             .viewId("/providers/Microsoft.CostManagement/views/swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdateScheduledActionByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledActionByScope = new AzureNative.CostManagement.ScheduledActionByScope("scheduledActionByScope", new()
 *     {
 *         DisplayName = "Monthly Cost By Resource",
 *         FileDestination = new AzureNative.CostManagement.Inputs.FileDestinationArgs
 *         {
 *             FileFormats = new[]
 *             {
 *                 AzureNative.CostManagement.FileFormat.Csv,
 *             },
 *         },
 *         Kind = AzureNative.CostManagement.ScheduledActionKind.Email,
 *         Name = "monthlyCostByResource",
 *         Notification = new AzureNative.CostManagement.Inputs.NotificationPropertiesArgs
 *         {
 *             Subject = "Cost by resource this month",
 *             To = new[]
 *             {
 *                 "user@gmail.com",
 *                 "team@gmail.com",
 *             },
 *         },
 *         Schedule = new AzureNative.CostManagement.Inputs.SchedulePropertiesArgs
 *         {
 *             DaysOfWeek = new[]
 *             {
 *                 AzureNative.CostManagement.DaysOfWeek.Monday,
 *             },
 *             EndDate = "2021-06-19T22:21:51.1287144Z",
 *             Frequency = AzureNative.CostManagement.ScheduleFrequency.Monthly,
 *             HourOfDay = 10,
 *             StartDate = "2020-06-19T22:21:51.1287144Z",
 *             WeeksOfMonth = new[]
 *             {
 *                 AzureNative.CostManagement.WeeksOfMonth.First,
 *                 AzureNative.CostManagement.WeeksOfMonth.Third,
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Status = AzureNative.CostManagement.ScheduledActionStatus.Enabled,
 *         ViewId = "/providers/Microsoft.CostManagement/views/swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewScheduledActionByScope(ctx, "scheduledActionByScope", &costmanagement.ScheduledActionByScopeArgs{
 * 			DisplayName: pulumi.String("Monthly Cost By Resource"),
 * 			FileDestination: &costmanagement.FileDestinationArgs{
 * 				FileFormats: pulumi.StringArray{
 * 					pulumi.String(costmanagement.FileFormatCsv),
 * 				},
 * 			},
 * 			Kind: pulumi.String(costmanagement.ScheduledActionKindEmail),
 * 			Name: pulumi.String("monthlyCostByResource"),
 * 			Notification: &costmanagement.NotificationPropertiesArgs{
 * 				Subject: pulumi.String("Cost by resource this month"),
 * 				To: pulumi.StringArray{
 * 					pulumi.String("user@gmail.com"),
 * 					pulumi.String("team@gmail.com"),
 * 				},
 * 			},
 * 			Schedule: &costmanagement.SchedulePropertiesArgs{
 * 				DaysOfWeek: pulumi.StringArray{
 * 					pulumi.String(costmanagement.DaysOfWeekMonday),
 * 				},
 * 				EndDate:   pulumi.String("2021-06-19T22:21:51.1287144Z"),
 * 				Frequency: pulumi.String(costmanagement.ScheduleFrequencyMonthly),
 * 				HourOfDay: pulumi.Int(10),
 * 				StartDate: pulumi.String("2020-06-19T22:21:51.1287144Z"),
 * 				WeeksOfMonth: pulumi.StringArray{
 * 					pulumi.String(costmanagement.WeeksOfMonthFirst),
 * 					pulumi.String(costmanagement.WeeksOfMonthThird),
 * 				},
 * 			},
 * 			Scope:  pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Status: pulumi.String(costmanagement.ScheduledActionStatusEnabled),
 * 			ViewId: pulumi.String("/providers/Microsoft.CostManagement/views/swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScope;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.FileDestinationArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledActionByScope = new ScheduledActionByScope("scheduledActionByScope", ScheduledActionByScopeArgs.builder()
 *             .displayName("Monthly Cost By Resource")
 *             .fileDestination(FileDestinationArgs.builder()
 *                 .fileFormats("Csv")
 *                 .build())
 *             .kind("Email")
 *             .name("monthlyCostByResource")
 *             .notification(NotificationPropertiesArgs.builder()
 *                 .subject("Cost by resource this month")
 *                 .to(
 *                     "user@gmail.com",
 *                     "team@gmail.com")
 *                 .build())
 *             .schedule(SchedulePropertiesArgs.builder()
 *                 .daysOfWeek("Monday")
 *                 .endDate("2021-06-19T22:21:51.1287144Z")
 *                 .frequency("Monthly")
 *                 .hourOfDay(10)
 *                 .startDate("2020-06-19T22:21:51.1287144Z")
 *                 .weeksOfMonth(
 *                     "First",
 *                     "Third")
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .status("Enabled")
 *             .viewId("/providers/Microsoft.CostManagement/views/swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:ScheduledActionByScope monthlyCostByResource /{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}
 * ```
 */
public class ScheduledActionByScope internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.ScheduledActionByScope,
) : KotlinCustomResource(javaResource, ScheduledActionByScopeMapper) {
    /**
     * Scheduled action name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then including the latest eTag as part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not required.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * Destination format of the view data. This is optional.
     */
    public val fileDestination: Output<FileDestinationResponse>?
        get() = javaResource.fileDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fileDestinationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Kind of the scheduled action.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notification properties based on scheduled action kind.
     */
    public val notification: Output<NotificationPropertiesResponse>
        get() = javaResource.notification().applyValue({ args0 ->
            args0.let({ args0 ->
                notificationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Email address of the point of contact that should get the unsubscribe requests and notification emails.
     */
    public val notificationEmail: Output<String>?
        get() = javaResource.notificationEmail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schedule of the scheduled action.
     */
    public val schedule: Output<SchedulePropertiesResponse>
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.let({ args0 ->
                schedulePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * For private scheduled action(Create or Update), scope will be empty.<br /> For shared scheduled action(Create or Update By Scope), Cost Management scope can be 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of the scheduled action.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Kind of the scheduled action.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
     */
    public val viewId: Output<String>
        get() = javaResource.viewId().applyValue({ args0 -> args0 })
}

public object ScheduledActionByScopeMapper : ResourceMapper<ScheduledActionByScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.ScheduledActionByScope::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledActionByScope =
        ScheduledActionByScope(
            javaResource as
                com.pulumi.azurenative.costmanagement.ScheduledActionByScope,
        )
}

/**
 * @see [ScheduledActionByScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledActionByScope].
 */
public suspend fun scheduledActionByScope(
    name: String,
    block: suspend ScheduledActionByScopeResourceBuilder.() -> Unit,
): ScheduledActionByScope {
    val builder = ScheduledActionByScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledActionByScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledActionByScope(name: String): ScheduledActionByScope {
    val builder = ScheduledActionByScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
