@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.SettingsPropertiesResponseCache
import com.pulumi.azurenative.costmanagement.kotlin.outputs.SettingsPropertiesResponseCache.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Setting].
 */
@PulumiTagMarker
public class SettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SettingArgs = SettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SettingArgsBuilder.() -> Unit) {
        val builder = SettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Setting {
        val builtJavaResource = com.pulumi.azurenative.costmanagement.Setting(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Setting(builtJavaResource)
    }
}

/**
 * State of the myscope setting.
 * Azure REST API version: 2019-11-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * ## Example Usage
 * ### CreateOrUpdateSetting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var setting = new AzureNative.CostManagement.Setting("setting", new()
 *     {
 *         Cache = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.SettingsPropertiesCacheArgs
 *             {
 *                 Channel = "Modern",
 *                 Id = "/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 Name = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 Parent = "/providers/Microsoft.Management/managementGroups/acm",
 *                 Status = "enabled",
 *                 Subchannel = "NotApplicable",
 *             },
 *         },
 *         Scope = "/subscriptions/00000000-0000-0000-0000-000000000000",
 *         SettingName = "myscope",
 *         StartOn = "LastUsed",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewSetting(ctx, "setting", &costmanagement.SettingArgs{
 * 			Cache: costmanagement.SettingsPropertiesCacheArray{
 * 				&costmanagement.SettingsPropertiesCacheArgs{
 * 					Channel:    pulumi.String("Modern"),
 * 					Id:         pulumi.String("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					Name:       pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					Parent:     pulumi.String("/providers/Microsoft.Management/managementGroups/acm"),
 * 					Status:     pulumi.String("enabled"),
 * 					Subchannel: pulumi.String("NotApplicable"),
 * 				},
 * 			},
 * 			Scope:       pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			SettingName: pulumi.String("myscope"),
 * 			StartOn:     pulumi.String("LastUsed"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Setting;
 * import com.pulumi.azurenative.costmanagement.SettingArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.SettingsPropertiesCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var setting = new Setting("setting", SettingArgs.builder()
 *             .cache(SettingsPropertiesCacheArgs.builder()
 *                 .channel("Modern")
 *                 .id("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 .name("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 .parent("/providers/Microsoft.Management/managementGroups/acm")
 *                 .status("enabled")
 *                 .subchannel("NotApplicable")
 *                 .build())
 *             .scope("/subscriptions/00000000-0000-0000-0000-000000000000")
 *             .settingName("myscope")
 *             .startOn("LastUsed")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:Setting myscope /providers/Microsoft.CostManagement/settings/{settingName}
 * ```
 */
public class Setting internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.Setting,
) : KotlinCustomResource(javaResource, SettingMapper) {
    /**
     * Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    public val cache: Output<List<SettingsPropertiesResponseCache>>?
        get() = javaResource.cache().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
     */
    public val startOn: Output<String>?
        get() = javaResource.startOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SettingMapper : ResourceMapper<Setting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.Setting::class == javaResource::class

    override fun map(javaResource: Resource): Setting = Setting(
        javaResource as
            com.pulumi.azurenative.costmanagement.Setting,
    )
}

/**
 * @see [Setting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Setting].
 */
public suspend fun setting(name: String, block: suspend SettingResourceBuilder.() -> Unit): Setting {
    val builder = SettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Setting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun setting(name: String): Setting {
    val builder = SettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
