@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.TagInheritancePropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.TagInheritancePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagInheritanceSetting].
 */
@PulumiTagMarker
public class TagInheritanceSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagInheritanceSettingArgs = TagInheritanceSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagInheritanceSettingArgsBuilder.() -> Unit) {
        val builder = TagInheritanceSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagInheritanceSetting {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.TagInheritanceSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TagInheritanceSetting(builtJavaResource)
    }
}

/**
 * Tag Inheritance Setting definition.
 * Azure REST API version: 2022-10-05-preview.
 * ## Example Usage
 * ### CreateOrUpdateSettingByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagInheritanceSetting = new AzureNative.CostManagement.TagInheritanceSetting("tagInheritanceSetting", new()
 *     {
 *         Kind = "taginheritance",
 *         Properties = new AzureNative.CostManagement.Inputs.TagInheritancePropertiesArgs
 *         {
 *             PreferContainerTags = false,
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Type = "taginheritance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewTagInheritanceSetting(ctx, "tagInheritanceSetting", &costmanagement.TagInheritanceSettingArgs{
 * 			Kind: pulumi.String("taginheritance"),
 * 			Properties: &costmanagement.TagInheritancePropertiesArgs{
 * 				PreferContainerTags: pulumi.Bool(false),
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Type:  pulumi.String("taginheritance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.TagInheritanceSetting;
 * import com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.TagInheritancePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagInheritanceSetting = new TagInheritanceSetting("tagInheritanceSetting", TagInheritanceSettingArgs.builder()
 *             .kind("taginheritance")
 *             .properties(TagInheritancePropertiesArgs.builder()
 *                 .preferContainerTags(false)
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .type("taginheritance")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:TagInheritanceSetting taginheritance /{scope}/providers/Microsoft.CostManagement/settings/{type}
 * ```
 */
public class TagInheritanceSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.TagInheritanceSetting,
) : KotlinCustomResource(javaResource, TagInheritanceSettingMapper) {
    /**
     * eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the kind of settings.
     * Expected value is 'taginheritance'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the tag inheritance setting.
     */
    public val properties: Output<TagInheritancePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagInheritanceSettingMapper : ResourceMapper<TagInheritanceSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.TagInheritanceSetting::class == javaResource::class

    override fun map(javaResource: Resource): TagInheritanceSetting =
        TagInheritanceSetting(
            javaResource as
                com.pulumi.azurenative.costmanagement.TagInheritanceSetting,
        )
}

/**
 * @see [TagInheritanceSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagInheritanceSetting].
 */
public suspend fun tagInheritanceSetting(
    name: String,
    block: suspend TagInheritanceSettingResourceBuilder.() -> Unit,
): TagInheritanceSetting {
    val builder = TagInheritanceSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagInheritanceSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagInheritanceSetting(name: String): TagInheritanceSetting {
    val builder = TagInheritanceSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
