@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The comparison operator.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Supported operators for **CategoryType: Cost**
 * - GreaterThan
 * - GreaterThanOrEqualTo
 *  Supported operators for **CategoryType: ReservationUtilization**
 * - LessThan
 */
public enum class BudgetNotificationOperatorType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType> {
    /**
     * Notification will be triggered if the evaluated cost is the same as threshold value. Note: It’s not recommended to use this OperatorType as there’s low chance of cost being exactly the same as threshold value, leading to missing of your alert. This OperatorType will be deprecated in future.
     *  Supported for CategoryType(s): Cost.
     */
    EqualTo(com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType.EqualTo),

    /**
     * Notification will be triggered if the evaluated cost is greater than the threshold value. Note: This is the recommended OperatorType while configuring Budget Alert.
     *  Supported for CategoryType(s): Cost.
     */
    GreaterThan(com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType.GreaterThan),

    /**
     * Notification will be triggered if the evaluated cost is greater than or equal to the threshold value.
     *  Supported for CategoryType(s): Cost.
     */
    GreaterThanOrEqualTo(com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType.GreaterThanOrEqualTo),

    /**
     * Notification will be triggered if any Reservations in the scope of the Reservation Utilization Alert Rule have a utilization less than the threshold percentage.
     *  Supported for CategoryType(s): ReservationUtilization.
     */
    LessThan(com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType.LessThan),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.BudgetNotificationOperatorType): BudgetNotificationOperatorType =
            BudgetNotificationOperatorType.values().first { it.javaValue == javaType }
    }
}
