@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of resources contained in this cost allocation rule
 */
public enum class CostAllocationResourceType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType> {
    /**
     * Indicates an Azure dimension such as a subscription id or resource group name is being used for allocation.
     */
    Dimension(com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType.Dimension),

    /**
     * Allocates cost based on Azure Tag key value pairs.
     */
    Tag(com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType.Tag),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.CostAllocationResourceType): CostAllocationResourceType =
            CostAllocationResourceType.values().first { it.javaValue == javaType }
    }
}
