@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Metric to use when displaying costs.
 */
public enum class MetricType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.MetricType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.MetricType> {
    ActualCost(com.pulumi.azurenative.costmanagement.enums.MetricType.ActualCost),
    AmortizedCost(com.pulumi.azurenative.costmanagement.enums.MetricType.AmortizedCost),
    AHUB(com.pulumi.azurenative.costmanagement.enums.MetricType.AHUB),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.MetricType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.MetricType): MetricType = MetricType.values().first { it.javaValue == javaType }
    }
}
