@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Has type of the column to group.
 */
public enum class QueryColumnType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.QueryColumnType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.QueryColumnType> {
    /**
     * The tag associated with the cost data.
     */
    TagKey(com.pulumi.azurenative.costmanagement.enums.QueryColumnType.TagKey),

    /**
     * The dimension of cost data.
     */
    Dimension(com.pulumi.azurenative.costmanagement.enums.QueryColumnType.Dimension),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.QueryColumnType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.QueryColumnType): QueryColumnType = QueryColumnType.values().first { it.javaValue == javaType }
    }
}
