@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the rule
 */
public enum class RuleStatus(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.RuleStatus,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.RuleStatus> {
    /**
     * Rule is saved but not used to allocate costs.
     */
    NotActive(com.pulumi.azurenative.costmanagement.enums.RuleStatus.NotActive),

    /**
     * Rule is saved and impacting cost allocation.
     */
    Active(com.pulumi.azurenative.costmanagement.enums.RuleStatus.Active),

    /**
     * Rule is saved and cost allocation is being updated. Readonly value that cannot be submitted in a put request.
     */
    Processing(com.pulumi.azurenative.costmanagement.enums.RuleStatus.Processing),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.RuleStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.RuleStatus): RuleStatus = RuleStatus.values().first { it.javaValue == javaType }
    }
}
