@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Kind of the scheduled action.
 */
public enum class ScheduledActionKind(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind> {
    /**
     * Cost analysis data will be emailed.
     */
    Email(com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind.Email),

    /**
     * Cost anomaly information will be emailed. Available only on subscription scope at daily frequency. If no anomaly is detected on the resource, an email won't be sent.
     */
    InsightAlert(com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind.InsightAlert),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ScheduledActionKind): ScheduledActionKind = ScheduledActionKind.values().first { it.javaValue == javaType }
    }
}
