@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportDefinitionArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ExportType
import com.pulumi.azurenative.costmanagement.kotlin.enums.TimeframeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The definition of an export.
 * @property dataSet The definition for data in the export.
 * @property timePeriod Has time period for pulling data for the export.
 * @property timeframe The time frame for pulling data for the export. If custom, then a specific time period must be provided.
 * @property type The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
 */
public data class ExportDefinitionArgs(
    public val dataSet: Output<ExportDatasetArgs>? = null,
    public val timePeriod: Output<ExportTimePeriodArgs>? = null,
    public val timeframe: Output<Either<String, TimeframeType>>,
    public val type: Output<Either<String, ExportType>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportDefinitionArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportDefinitionArgs.builder()
            .dataSet(dataSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timePeriod(timePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeframe(
                timeframe.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportDefinitionArgs].
 */
@PulumiTagMarker
public class ExportDefinitionArgsBuilder internal constructor() {
    private var dataSet: Output<ExportDatasetArgs>? = null

    private var timePeriod: Output<ExportTimePeriodArgs>? = null

    private var timeframe: Output<Either<String, TimeframeType>>? = null

    private var type: Output<Either<String, ExportType>>? = null

    /**
     * @param value The definition for data in the export.
     */
    @JvmName("cqirwbggsnnmrdot")
    public suspend fun dataSet(`value`: Output<ExportDatasetArgs>) {
        this.dataSet = value
    }

    /**
     * @param value Has time period for pulling data for the export.
     */
    @JvmName("rprvaxkgbmrxkbll")
    public suspend fun timePeriod(`value`: Output<ExportTimePeriodArgs>) {
        this.timePeriod = value
    }

    /**
     * @param value The time frame for pulling data for the export. If custom, then a specific time period must be provided.
     */
    @JvmName("qrjfflafcfleibct")
    public suspend fun timeframe(`value`: Output<Either<String, TimeframeType>>) {
        this.timeframe = value
    }

    /**
     * @param value The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
     */
    @JvmName("bwgvbwxsghhmsncj")
    public suspend fun type(`value`: Output<Either<String, ExportType>>) {
        this.type = value
    }

    /**
     * @param value The definition for data in the export.
     */
    @JvmName("urcawuxokmnxetsh")
    public suspend fun dataSet(`value`: ExportDatasetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSet = mapped
    }

    /**
     * @param argument The definition for data in the export.
     */
    @JvmName("xpaqktbayggqnmek")
    public suspend fun dataSet(argument: suspend ExportDatasetArgsBuilder.() -> Unit) {
        val toBeMapped = ExportDatasetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSet = mapped
    }

    /**
     * @param value Has time period for pulling data for the export.
     */
    @JvmName("anqtnnfynfheyown")
    public suspend fun timePeriod(`value`: ExportTimePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    /**
     * @param argument Has time period for pulling data for the export.
     */
    @JvmName("bcuyrlmmtmhkvnlw")
    public suspend fun timePeriod(argument: suspend ExportTimePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = ExportTimePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timePeriod = mapped
    }

    /**
     * @param value The time frame for pulling data for the export. If custom, then a specific time period must be provided.
     */
    @JvmName("nsifmlhjxoaqtxmb")
    public suspend fun timeframe(`value`: Either<String, TimeframeType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the export. If custom, then a specific time period must be provided.
     */
    @JvmName("ikwrjcdvqujblfve")
    public fun timeframe(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the export. If custom, then a specific time period must be provided.
     */
    @JvmName("fhdrpjhnexiylmrx")
    public fun timeframe(`value`: TimeframeType) {
        val toBeMapped = Either.ofRight<String, TimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
     */
    @JvmName("qtydhixefhhfievj")
    public suspend fun type(`value`: Either<String, ExportType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
     */
    @JvmName("ghkeeohwqddtxhck")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
     */
    @JvmName("jppbmuhwimeasdem")
    public fun type(`value`: ExportType) {
        val toBeMapped = Either.ofRight<String, ExportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExportDefinitionArgs = ExportDefinitionArgs(
        dataSet = dataSet,
        timePeriod = timePeriod,
        timeframe = timeframe ?: throw PulumiNullFieldException("timeframe"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
