@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetMarkupRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountId BillingAccount ID
 * @property billingProfileId BillingProfile ID
 * @property name Markup rule name.
 */
public data class GetMarkupRulePlainArgs(
    public val billingAccountId: String,
    public val billingProfileId: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetMarkupRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetMarkupRulePlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetMarkupRulePlainArgs.builder()
            .billingAccountId(billingAccountId.let({ args0 -> args0 }))
            .billingProfileId(billingProfileId.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMarkupRulePlainArgs].
 */
@PulumiTagMarker
public class GetMarkupRulePlainArgsBuilder internal constructor() {
    private var billingAccountId: String? = null

    private var billingProfileId: String? = null

    private var name: String? = null

    /**
     * @param value BillingAccount ID
     */
    @JvmName("lmbqjuucfbfnqdjr")
    public suspend fun billingAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountId = mapped
    }

    /**
     * @param value BillingProfile ID
     */
    @JvmName("aawettpgbdjtkidr")
    public suspend fun billingProfileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingProfileId = mapped
    }

    /**
     * @param value Markup rule name.
     */
    @JvmName("xyqayaglejhgrtak")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetMarkupRulePlainArgs = GetMarkupRulePlainArgs(
        billingAccountId = billingAccountId ?: throw PulumiNullFieldException("billingAccountId"),
        billingProfileId = billingProfileId ?: throw PulumiNullFieldException("billingProfileId"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
