@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetReportByBillingAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountId BillingAccount ID
 * @property reportName Report Name.
 */
public data class GetReportByBillingAccountPlainArgs(
    public val billingAccountId: String,
    public val reportName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetReportByBillingAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetReportByBillingAccountPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetReportByBillingAccountPlainArgs.builder()
            .billingAccountId(billingAccountId.let({ args0 -> args0 }))
            .reportName(reportName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReportByBillingAccountPlainArgs].
 */
@PulumiTagMarker
public class GetReportByBillingAccountPlainArgsBuilder internal constructor() {
    private var billingAccountId: String? = null

    private var reportName: String? = null

    /**
     * @param value BillingAccount ID
     */
    @JvmName("xpjiufnskjhferrh")
    public suspend fun billingAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountId = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("pyewgdhyjxbhiuqh")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    internal fun build(): GetReportByBillingAccountPlainArgs = GetReportByBillingAccountPlainArgs(
        billingAccountId = billingAccountId ?: throw PulumiNullFieldException("billingAccountId"),
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
    )
}
