@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetReportPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reportName Report Name.
 */
public data class GetReportPlainArgs(
    public val reportName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetReportPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetReportPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetReportPlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReportPlainArgs].
 */
@PulumiTagMarker
public class GetReportPlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    /**
     * @param value Report Name.
     */
    @JvmName("puyxuaulpwhgyftf")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    internal fun build(): GetReportPlainArgs = GetReportPlainArgs(
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
    )
}
