@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.PivotPropertiesArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.PivotTypeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Each pivot must contain a 'type' and 'name'.
 * @property name Data field to show in view.
 * @property type Data type to show in view.
 */
public data class PivotPropertiesArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, PivotTypeType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.PivotPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.PivotPropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.PivotPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PivotPropertiesArgs].
 */
@PulumiTagMarker
public class PivotPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, PivotTypeType>>? = null

    /**
     * @param value Data field to show in view.
     */
    @JvmName("jejqiedgjqliofbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Data type to show in view.
     */
    @JvmName("rcfybqnlulfbgmie")
    public suspend fun type(`value`: Output<Either<String, PivotTypeType>>) {
        this.type = value
    }

    /**
     * @param value Data field to show in view.
     */
    @JvmName("hdyiomnnrgygsaxj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Data type to show in view.
     */
    @JvmName("lrskpoulmadjspcm")
    public suspend fun type(`value`: Either<String, PivotTypeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data type to show in view.
     */
    @JvmName("nfrjpjpueddhgqsd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PivotTypeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data type to show in view.
     */
    @JvmName("fobjkvdahflgujnq")
    public fun type(`value`: PivotTypeType) {
        val toBeMapped = Either.ofRight<String, PivotTypeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PivotPropertiesArgs = PivotPropertiesArgs(
        name = name,
        type = type,
    )
}
