@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportGroupingArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportColumnType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The group by expression to be used in the report.
 * @property name The name of the column to group.
 * @property type Has type of the column to group.
 */
public data class ReportGroupingArgs(
    public val name: Output<String>,
    public val type: Output<Either<String, ReportColumnType>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportGroupingArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportGroupingArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportGroupingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportGroupingArgs].
 */
@PulumiTagMarker
public class ReportGroupingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, ReportColumnType>>? = null

    /**
     * @param value The name of the column to group.
     */
    @JvmName("eovwcxmjrkwsoygr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("kpsleokpyrioldhl")
    public suspend fun type(`value`: Output<Either<String, ReportColumnType>>) {
        this.type = value
    }

    /**
     * @param value The name of the column to group.
     */
    @JvmName("tbepavaytcwydecv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("fiudsqpvkwdixqdc")
    public suspend fun type(`value`: Either<String, ReportColumnType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("qctrslrsgmhgyjxi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("qwanhqenughgnvah")
    public fun type(`value`: ReportColumnType) {
        val toBeMapped = Either.ofRight<String, ReportColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportGroupingArgs = ReportGroupingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
