@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportTimePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The start and end date for pulling data for the report.
 * @property from The start date to pull data from.
 * @property to The end date to pull data to.
 */
public data class ReportTimePeriodArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportTimePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportTimePeriodArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportTimePeriodArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportTimePeriodArgs].
 */
@PulumiTagMarker
public class ReportTimePeriodArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value The start date to pull data from.
     */
    @JvmName("hhhcrbxnlminsuto")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value The end date to pull data to.
     */
    @JvmName("vqopsosryxxfxvhk")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value The start date to pull data from.
     */
    @JvmName("nneutbnednjtdfdr")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value The end date to pull data to.
     */
    @JvmName("cleciuggwdjctooj")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ReportTimePeriodArgs = ReportTimePeriodArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
