@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.SettingsPropertiesCacheArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channel Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
 * @property id Resource ID used by Resource Manager to uniquely identify the scope.
 * @property name Display name for the scope.
 * @property parent Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
 * @property status Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
 * @property subchannel Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
 */
public data class SettingsPropertiesCacheArgs(
    public val channel: Output<String>,
    public val id: Output<String>,
    public val name: Output<String>,
    public val parent: Output<String>? = null,
    public val status: Output<String>? = null,
    public val subchannel: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.SettingsPropertiesCacheArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.SettingsPropertiesCacheArgs =
        com.pulumi.azurenative.costmanagement.inputs.SettingsPropertiesCacheArgs.builder()
            .channel(channel.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parent(parent?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .subchannel(subchannel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SettingsPropertiesCacheArgs].
 */
@PulumiTagMarker
public class SettingsPropertiesCacheArgsBuilder internal constructor() {
    private var channel: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var parent: Output<String>? = null

    private var status: Output<String>? = null

    private var subchannel: Output<String>? = null

    /**
     * @param value Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
     */
    @JvmName("jgcblrlvpdimdugc")
    public suspend fun channel(`value`: Output<String>) {
        this.channel = value
    }

    /**
     * @param value Resource ID used by Resource Manager to uniquely identify the scope.
     */
    @JvmName("qrwocwbyrbmwewvb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Display name for the scope.
     */
    @JvmName("dybsxpmrngasdivc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
     */
    @JvmName("eefqafnlmbxarllk")
    public suspend fun parent(`value`: Output<String>) {
        this.parent = value
    }

    /**
     * @param value Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
     */
    @JvmName("lrhfpnydwhbrdnpu")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
     */
    @JvmName("ltljdmpiuxjfwape")
    public suspend fun subchannel(`value`: Output<String>) {
        this.subchannel = value
    }

    /**
     * @param value Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
     */
    @JvmName("upfmvjjhukqnndbg")
    public suspend fun channel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channel = mapped
    }

    /**
     * @param value Resource ID used by Resource Manager to uniquely identify the scope.
     */
    @JvmName("fpsirnppwyeasybl")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Display name for the scope.
     */
    @JvmName("wdtlttlyhsprxgsv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
     */
    @JvmName("qnyafeqbmbbdccjm")
    public suspend fun parent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parent = mapped
    }

    /**
     * @param value Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
     */
    @JvmName("ffatpppayqstvlvu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
     */
    @JvmName("dvwcclskosoclamu")
    public suspend fun subchannel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subchannel = mapped
    }

    internal fun build(): SettingsPropertiesCacheArgs = SettingsPropertiesCacheArgs(
        channel = channel ?: throw PulumiNullFieldException("channel"),
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
        parent = parent,
        status = status,
        subchannel = subchannel ?: throw PulumiNullFieldException("subchannel"),
    )
}
