@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * May be used to filter budgets by user-specified dimensions and/or tags.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property and The logical "AND" expression. Must have at least 2 items.
 *  Supported for CategoryType(s): Cost.
 * @property dimensions Has comparison expression for a dimension.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * Supported dimension names for **CategoryType: ReservationUtilization**
 * - ReservationId
 * - ReservedResourceType
 * @property tags Has comparison expression for a tag.
 *  Supported for CategoryType(s): Cost.
 */
public data class BudgetFilterResponse(
    public val and: List<BudgetFilterPropertiesResponse>? = null,
    public val dimensions: BudgetComparisonExpressionResponse? = null,
    public val tags: BudgetComparisonExpressionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.BudgetFilterResponse): BudgetFilterResponse = BudgetFilterResponse(
            and = javaType.and().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetFilterPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
