@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Required for CategoryType(s): Cost, ReservationUtilization.
 * @property endDate The end date for the budget.
 * - Constraints for **CategoryType: Cost** - No constraints. If not provided, we default this to 10 years from the start date.
 * - Constraints for **CategoryType: ReservationUtilization** - End date cannot be more than 3 years after the start date.
 * @property startDate The start date for the budget.
 * - Constraints for **CategoryType: Cost** - Must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period.
 * - Constraints for **CategoryType: ReservationUtilization** - Must be on or after the current date and less than the end date.
 */
public data class BudgetTimePeriodResponse(
    public val endDate: String? = null,
    public val startDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.BudgetTimePeriodResponse): BudgetTimePeriodResponse = BudgetTimePeriodResponse(
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate(),
        )
    }
}
