@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of any error encountered on last collection attempt
 * @property errorCode Short error message
 * @property errorInnerMessage External Provider error message
 * @property errorMessage Detailed error message
 * @property errorStartTime Time the error started occurring (Last time error occurred in lastRun)
 */
public data class ConnectorCollectionErrorInfoResponse(
    public val errorCode: String,
    public val errorInnerMessage: String? = null,
    public val errorMessage: String,
    public val errorStartTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ConnectorCollectionErrorInfoResponse): ConnectorCollectionErrorInfoResponse = ConnectorCollectionErrorInfoResponse(
            errorCode = javaType.errorCode(),
            errorInnerMessage = javaType.errorInnerMessage().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage(),
            errorStartTime = javaType.errorStartTime(),
        )
    }
}
