@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a cost allocation rule
 * @property createdDate Time at which the rule was created. Rules that change cost for the same resource are applied in order of creation.
 * @property description Description of a cost allocation rule.
 * @property details Resource information for the cost allocation rule
 * @property status Status of the rule
 * @property updatedDate Time at which the rule was last updated.
 */
public data class CostAllocationRulePropertiesResponse(
    public val createdDate: String,
    public val description: String? = null,
    public val details: CostAllocationRuleDetailsResponse,
    public val status: String,
    public val updatedDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.CostAllocationRulePropertiesResponse): CostAllocationRulePropertiesResponse = CostAllocationRulePropertiesResponse(
            createdDate = javaType.createdDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.CostAllocationRuleDetailsResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
            updatedDate = javaType.updatedDate(),
        )
    }
}
