@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The customer billing metadata
 * @property billingAccountId Customer billing account id
 * @property billingProfileId Customer billing profile id
 */
public data class CustomerMetadataResponse(
    public val billingAccountId: String,
    public val billingProfileId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.CustomerMetadataResponse): CustomerMetadataResponse = CustomerMetadataResponse(
            billingAccountId = javaType.billingAccountId(),
            billingProfileId = javaType.billingProfileId(),
        )
    }
}
