@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the error.
 * @property code Error code.
 * @property message Error message indicating why the operation failed.
 */
public data class ErrorDetailsResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ErrorDetailsResponse): ErrorDetailsResponse = ErrorDetailsResponse(
            code = javaType.code(),
            message = javaType.message(),
        )
    }
}
