@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
 * @property columns Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
 */
public data class ExportDatasetConfigurationResponse(
    public val columns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportDatasetConfigurationResponse): ExportDatasetConfigurationResponse = ExportDatasetConfigurationResponse(
            columns = javaType.columns().map({ args0 -> args0 }),
        )
    }
}
