@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The definition for data in the export.
 * @property configuration The export dataset configuration.
 * @property granularity The granularity of rows in the export. Currently only 'Daily' is supported.
 */
public data class ExportDatasetResponse(
    public val configuration: ExportDatasetConfigurationResponse? = null,
    public val granularity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportDatasetResponse): ExportDatasetResponse = ExportDatasetResponse(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDatasetConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            granularity = javaType.granularity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
