@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The definition of an export.
 * @property dataSet The definition for data in the export.
 * @property timePeriod Has time period for pulling data for the export.
 * @property timeframe The time frame for pulling data for the export. If custom, then a specific time period must be provided.
 * @property type The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
 */
public data class ExportDefinitionResponse(
    public val dataSet: ExportDatasetResponse? = null,
    public val timePeriod: ExportTimePeriodResponse? = null,
    public val timeframe: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportDefinitionResponse): ExportDefinitionResponse = ExportDefinitionResponse(
            dataSet = javaType.dataSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDatasetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timePeriod = javaType.timePeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportTimePeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeframe = javaType.timeframe(),
            type = javaType.type(),
        )
    }
}
