@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The start and end date for recurrence schedule.
 * @property from The start date of recurrence.
 * @property to The end date of recurrence.
 */
public data class ExportRecurrencePeriodResponse(
    public val from: String,
    public val to: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportRecurrencePeriodResponse): ExportRecurrencePeriodResponse = ExportRecurrencePeriodResponse(
            from = javaType.from(),
            to = javaType.to().map({ args0 -> args0 }).orElse(null),
        )
    }
}
