@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An export run.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property error The details of any error.
 * @property executionType The type of the export run.
 * @property fileName The name of the exported file.
 * @property id Resource Id.
 * @property name Resource name.
 * @property processingEndTime The time when the export run finished.
 * @property processingStartTime The time when export was picked up to be run.
 * @property runSettings The export settings that were in effect for this run.
 * @property status The last known status of the export run.
 * @property submittedBy The identifier for the entity that triggered the export. For on-demand runs it is the user email. For scheduled runs it is 'System'.
 * @property submittedTime The time when export was queued to be run.
 * @property type Resource type.
 */
public data class ExportRunResponse(
    public val eTag: String? = null,
    public val error: ErrorDetailsResponse? = null,
    public val executionType: String? = null,
    public val fileName: String? = null,
    public val id: String,
    public val name: String,
    public val processingEndTime: String? = null,
    public val processingStartTime: String? = null,
    public val runSettings: CommonExportPropertiesResponse? = null,
    public val status: String? = null,
    public val submittedBy: String? = null,
    public val submittedTime: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportRunResponse): ExportRunResponse = ExportRunResponse(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            executionType = javaType.executionType().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            processingEndTime = javaType.processingEndTime().map({ args0 -> args0 }).orElse(null),
            processingStartTime = javaType.processingStartTime().map({ args0 -> args0 }).orElse(null),
            runSettings = javaType.runSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.CommonExportPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            submittedBy = javaType.submittedBy().map({ args0 -> args0 }).orElse(null),
            submittedTime = javaType.submittedTime().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
