@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The schedule associated with the export.
 * @property recurrence The schedule recurrence.
 * @property recurrencePeriod Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
 * @property status The status of the export's schedule. If 'Inactive', the export's schedule is paused.
 */
public data class ExportScheduleResponse(
    public val recurrence: String? = null,
    public val recurrencePeriod: ExportRecurrencePeriodResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportScheduleResponse): ExportScheduleResponse = ExportScheduleResponse(
            recurrence = javaType.recurrence().map({ args0 -> args0 }).orElse(null),
            recurrencePeriod = javaType.recurrencePeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportRecurrencePeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
