@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
 * @property from The start date for export data.
 * @property to The end date for export data.
 */
public data class ExportTimePeriodResponse(
    public val from: String,
    public val to: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ExportTimePeriodResponse): ExportTimePeriodResponse = ExportTimePeriodResponse(
            from = javaType.from(),
            to = javaType.to(),
        )
    }
}
