@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Destination of the view data. This is optional. Currently only CSV format is supported.
 * @property fileFormats Destination of the view data. Currently only CSV format is supported.
 */
public data class FileDestinationResponse(
    public val fileFormats: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.FileDestinationResponse): FileDestinationResponse = FileDestinationResponse(
            fileFormats = javaType.fileFormats().map({ args0 -> args0 }),
        )
    }
}
