@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The forecasted cost which is being tracked for a budget.
 *  Supported for CategoryType(s): Cost.
 * @property amount The forecasted cost for the total time period which is being tracked by the budget. This value is only provided if the budget contains a forecast alert type.
 * @property unit The unit of measure for the budget amount.
 */
public data class ForecastSpendResponse(
    public val amount: Double,
    public val unit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ForecastSpendResponse): ForecastSpendResponse = ForecastSpendResponse(
            amount = javaType.amount(),
            unit = javaType.unit(),
        )
    }
}
