@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Connector model definition
 * @property billingModel Connector billing model
 * @property collectionInfo Collection information
 * @property createdOn Connector definition creation datetime
 * @property credentialsKey Credentials authentication key (eg AWS ARN)
 * @property daysTrialRemaining Number of days remaining of trial
 * @property defaultManagementGroupId Default ManagementGroupId
 * @property displayName Connector DisplayName
 * @property externalBillingAccountId Associated ExternalBillingAccountId
 * @property id Connector id
 * @property kind Connector kind (eg aws)
 * @property modifiedOn Connector last modified datetime
 * @property name Connector name
 * @property providerBillingAccountDisplayName The display name of the providerBillingAccountId as defined on the external provider
 * @property providerBillingAccountId Connector providerBillingAccountId, determined from credentials (eg AWS Consolidated account number)
 * @property reportId Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
 * @property status Connector status
 * @property subscriptionId Billing SubscriptionId
 * @property type Connector type
 */
public data class GetCloudConnectorResult(
    public val billingModel: String? = null,
    public val collectionInfo: ConnectorCollectionInfoResponse,
    public val createdOn: String,
    public val credentialsKey: String? = null,
    public val daysTrialRemaining: Int,
    public val defaultManagementGroupId: String? = null,
    public val displayName: String? = null,
    public val externalBillingAccountId: String,
    public val id: String,
    public val kind: String? = null,
    public val modifiedOn: String,
    public val name: String,
    public val providerBillingAccountDisplayName: String,
    public val providerBillingAccountId: String,
    public val reportId: String? = null,
    public val status: String,
    public val subscriptionId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetCloudConnectorResult): GetCloudConnectorResult = GetCloudConnectorResult(
            billingModel = javaType.billingModel().map({ args0 -> args0 }).orElse(null),
            collectionInfo = javaType.collectionInfo().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse.Companion.toKotlin(args0)
            }),
            createdOn = javaType.createdOn(),
            credentialsKey = javaType.credentialsKey().map({ args0 -> args0 }).orElse(null),
            daysTrialRemaining = javaType.daysTrialRemaining(),
            defaultManagementGroupId = javaType.defaultManagementGroupId().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            externalBillingAccountId = javaType.externalBillingAccountId(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            modifiedOn = javaType.modifiedOn(),
            name = javaType.name(),
            providerBillingAccountDisplayName = javaType.providerBillingAccountDisplayName(),
            providerBillingAccountId = javaType.providerBillingAccountId(),
            reportId = javaType.reportId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
