@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Markup rule
 * @property customerDetails Customer information for the markup rule.
 * @property description The description of the markup rule.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property endDate Ending date of the markup rule.
 * @property id Resource Id.
 * @property name Resource name.
 * @property percentage The markup percentage of the rule.
 * @property startDate Starting date of the markup rule.
 * @property type Resource type.
 */
public data class GetMarkupRuleResult(
    public val customerDetails: CustomerMetadataResponse,
    public val description: String? = null,
    public val eTag: String? = null,
    public val endDate: String? = null,
    public val id: String,
    public val name: String,
    public val percentage: Double,
    public val startDate: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetMarkupRuleResult): GetMarkupRuleResult = GetMarkupRuleResult(
            customerDetails = javaType.customerDetails().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.CustomerMetadataResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            percentage = javaType.percentage(),
            startDate = javaType.startDate(),
            type = javaType.type(),
        )
    }
}
