@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * State of the myscope setting.
 * @property cache Array of scopes with additional details used by Cost Management in the Azure portal.
 * @property id Resource Id.
 * @property kind Resource kind.
 * @property name Resource name.
 * @property scope Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
 * @property startOn Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
 * @property type Resource type.
 */
public data class GetSettingResult(
    public val cache: List<SettingsPropertiesResponseCache>? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val scope: String,
    public val startOn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetSettingResult): GetSettingResult = GetSettingResult(
            cache = javaType.cache().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.SettingsPropertiesResponseCache.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            scope = javaType.scope(),
            startOn = javaType.startOn().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
