@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tag Inheritance Setting definition.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property id Resource Id.
 * @property kind Specifies the kind of settings.
 * Expected value is 'taginheritance'.
 * @property name Resource name.
 * @property properties The properties of the tag inheritance setting.
 * @property type Resource type.
 */
public data class GetTagInheritanceSettingResult(
    public val eTag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val properties: TagInheritancePropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetTagInheritanceSettingResult): GetTagInheritanceSettingResult = GetTagInheritanceSettingResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.TagInheritancePropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
