@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Each pivot must contain a 'type' and 'name'.
 * @property name Data field to show in view.
 * @property type Data type to show in view.
 */
public data class PivotPropertiesResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.PivotPropertiesResponse): PivotPropertiesResponse = PivotPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
