@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The aggregation expression to be used in the report.
 * @property function The name of the aggregation function to use.
 * @property name The name of the column to aggregate.
 */
public data class ReportConfigAggregationResponse(
    public val function: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportConfigAggregationResponse): ReportConfigAggregationResponse = ReportConfigAggregationResponse(
            function = javaType.function(),
            name = javaType.name(),
        )
    }
}
