@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The filter expression to be used in the report.
 * @property and The logical "AND" expression. Must have at least 2 items.
 * @property dimensions Has comparison expression for a dimension
 * @property or The logical "OR" expression. Must have at least 2 items.
 * @property tags Has comparison expression for a tag
 */
public data class ReportConfigFilterResponse(
    public val and: List<ReportConfigFilterResponse>? = null,
    public val dimensions: ReportConfigComparisonExpressionResponse? = null,
    public val or: List<ReportConfigFilterResponse>? = null,
    public val tags: ReportConfigComparisonExpressionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportConfigFilterResponse): ReportConfigFilterResponse = ReportConfigFilterResponse(
            and = javaType.and().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigFilterResponse.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            or = javaType.or().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigFilterResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
