@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The start and end date for pulling data for the report.
 * @property from The start date to pull data from.
 * @property to The end date to pull data to.
 */
public data class ReportConfigTimePeriodResponse(
    public val from: String,
    public val to: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportConfigTimePeriodResponse): ReportConfigTimePeriodResponse = ReportConfigTimePeriodResponse(
            from = javaType.from(),
            to = javaType.to(),
        )
    }
}
