@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The definition of data present in the report.
 * @property aggregation Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
 * @property configuration Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
 * @property filter Has filter expression to use in the report.
 * @property granularity The granularity of rows in the report.
 * @property grouping Array of group by expression to use in the report. Report can have up to 2 group by clauses.
 */
public data class ReportDatasetResponse(
    public val aggregation: Map<String, ReportAggregationResponse>? = null,
    public val configuration: ReportDatasetConfigurationResponse? = null,
    public val filter: ReportFilterResponse? = null,
    public val granularity: String? = null,
    public val grouping: List<ReportGroupingResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportDatasetResponse): ReportDatasetResponse = ReportDatasetResponse(
            aggregation = javaType.aggregation().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportAggregationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDatasetConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            granularity = javaType.granularity().map({ args0 -> args0 }).orElse(null),
            grouping = javaType.grouping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportGroupingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
