@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The definition of a report.
 * @property dataset Has definition for data in this report.
 * @property timePeriod Has time period for pulling data for the report.
 * @property timeframe The time frame for pulling data for the report. If custom, then a specific time period must be provided.
 * @property type The type of the report.
 */
public data class ReportDefinitionResponse(
    public val dataset: ReportDatasetResponse? = null,
    public val timePeriod: ReportTimePeriodResponse? = null,
    public val timeframe: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportDefinitionResponse): ReportDefinitionResponse = ReportDefinitionResponse(
            dataset = javaType.dataset().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDatasetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timePeriod = javaType.timePeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportTimePeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeframe = javaType.timeframe(),
            type = javaType.type(),
        )
    }
}
