@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The group by expression to be used in the report.
 * @property name The name of the column to group.
 * @property type Has type of the column to group.
 */
public data class ReportGroupingResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportGroupingResponse): ReportGroupingResponse = ReportGroupingResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
