@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The schedule associated with a report.
 * @property recurrence The schedule recurrence.
 * @property recurrencePeriod Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
 * @property status The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
 */
public data class ReportScheduleResponse(
    public val recurrence: String,
    public val recurrencePeriod: ReportRecurrencePeriodResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportScheduleResponse): ReportScheduleResponse = ReportScheduleResponse(
            recurrence = javaType.recurrence(),
            recurrencePeriod = javaType.recurrencePeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportRecurrencePeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
