@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The properties of the tag inheritance setting.
 * @property preferContainerTags When resource has the same tag as subscription or resource group and this property is set to true - the subscription or resource group tag will be applied. If subscription and resource group tags are also the same, subscription tag will be applied.
 */
public data class TagInheritancePropertiesResponse(
    public val preferContainerTags: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.TagInheritancePropertiesResponse): TagInheritancePropertiesResponse = TagInheritancePropertiesResponse(
            preferContainerTags = javaType.preferContainerTags(),
        )
    }
}
