@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Target resources for cost allocation.
 * @property name If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
 * @property policyType Method of cost allocation for the rule
 * @property resourceType Type of resources contained in this cost allocation rule
 * @property values Target resources for cost allocation. This list cannot contain more than 25 values.
 */
public data class TargetCostAllocationResourceResponse(
    public val name: String,
    public val policyType: String,
    public val resourceType: String,
    public val values: List<CostAllocationProportionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.TargetCostAllocationResourceResponse): TargetCostAllocationResourceResponse = TargetCostAllocationResourceResponse(
            name = javaType.name(),
            policyType = javaType.policyType(),
            resourceType = javaType.resourceType(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.CostAllocationProportionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
